<?php
/**
 * File: ConfigSettingsTabsKeys.php
 *
 * @package W3TC
 */

namespace W3TC;

return array(
	'page_cache'     => array(
		'tabs' => array(
			'premium_support' => '<h3>' . esc_html__( 'Did you know that W3 Total Cache has premium services available, and can set up page cache for you?', 'w3-total-cache' ) . '</h3>
				<h4>' . esc_html__( 'Our more popular package is the Plugin Configuration package. Not only will we configure page caching for you, we will configure the object cache, database cache, and most other items too.', 'w3-total-cache' ) . '</h4>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Tailored W3 Total Cache setup, customized for your theme, plugins, and server.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Expert optimization based on WordPress-specific performance needs (WPO).', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Avoid harmful configurations like improper minification or caching.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Receive a detailed performance report with improvements and recommendations.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Proven to boost your site speed—ideal for unique traffic and site needs.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Start your optimization journey with W3 Total Cache as the foundation.', 'w3-total-cache' ) . '</p>

				<div class="cta-button">
					<a href="' . esc_url( Util_UI::admin_url( 'admin.php?page=w3tc_support' ) ) . '"> ' . esc_html__( 'Click here to purchase this premium service', 'w3-total-cache' ) . ' </a>
				</div>',
		),
	),
	'minify'         => array(
		'tabs' => array(
			'premium_support' => '<h3>' . esc_html__( 'Did you know that W3 Total Cache has premium services available, and can set up minify options for you?', 'w3-total-cache' ) . '</h3>
				<h4>' . esc_html__( 'Our more popular package is the Plugin Configuration package. Not only will we configure minify options for you, we will configure the object cache, database cache, and most other items too.', 'w3-total-cache' ) . '</h4>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Tailored W3 Total Cache setup, customized for your theme, plugins, and server.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Expert optimization based on WordPress-specific performance needs (WPO).', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Avoid harmful configurations like improper minification or caching.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Receive a detailed performance report with improvements and recommendations.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Proven to boost your site speed—ideal for unique traffic and site needs.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Start your optimization journey with W3 Total Cache as the foundation.', 'w3-total-cache' ) . '</p>

				<div class="cta-button">
					<a href="' . esc_url( Util_UI::admin_url( 'admin.php?page=w3tc_support' ) ) . '"> ' . esc_html__( 'Click here to purchase this premium service', 'w3-total-cache' ) . ' </a>
				</div>',
		),
	),
	'database_cache' => array(
		'tabs' => array(
			'premium_support' => '<h3>' . esc_html__( 'Did you know that W3 Total Cache has premium services available, and can set up database cache for you?', 'w3-total-cache' ) . '</h3>
				<h4>' . esc_html__( 'Our more popular package is the Plugin Configuration package. Not only will we configure database caching for you, we will configure the object cache, page cache, and most other items too.', 'w3-total-cache' ) . '</h4>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Tailored W3 Total Cache setup, customized for your theme, plugins, and server.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Expert optimization based on WordPress-specific performance needs (WPO).', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Avoid harmful configurations like improper minification or caching.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Receive a detailed performance report with improvements and recommendations.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Proven to boost your site speed—ideal for unique traffic and site needs.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Start your optimization journey with W3 Total Cache as the foundation.', 'w3-total-cache' ) . '</p>

				<div class="cta-button">
					<a href="' . esc_url( Util_UI::admin_url( 'admin.php?page=w3tc_support' ) ) . '"> ' . esc_html__( 'Click here to purchase this premium service', 'w3-total-cache' ) . ' </a>
				</div>',
		),
	),
	'object_cache'   => array(
		'tabs' => array(
			'premium_support' => '<h3>' . esc_html__( 'Did you know that W3 Total Cache has premium services available, and can set up object cache for you?', 'w3-total-cache' ) . '</h3>
				<h4>' . esc_html__( 'Our more popular package is the Plugin Configuration package. Not only will we configure object caching for you, we will configure the page cache, database cache, and most other items too.', 'w3-total-cache' ) . '</h4>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Tailored W3 Total Cache setup, customized for your theme, plugins, and server.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Expert optimization based on WordPress-specific performance needs (WPO).', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Avoid harmful configurations like improper minification or caching.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Receive a detailed performance report with improvements and recommendations.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Proven to boost your site speed—ideal for unique traffic and site needs.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Start your optimization journey with W3 Total Cache as the foundation.', 'w3-total-cache' ) . '</p>

				<div class="cta-button">
					<a href="' . esc_url( Util_UI::admin_url( 'admin.php?page=w3tc_support' ) ) . '"> ' . esc_html__( 'Click here to purchase this premium service', 'w3-total-cache' ) . ' </a>
				</div>',
		),
	),
	'browser_cache'  => array(
		'tabs' => array(
			'premium_support' => '<h3>' . esc_html__( 'Did you know that W3 Total Cache has premium services available, and can set up browser cache for you?', 'w3-total-cache' ) . '</h3>
				<h4>' . esc_html__( 'Our more popular package is the Plugin Configuration package. Not only will we configure browser caching for you, we will configure the object cache, database cache, and most other items too.', 'w3-total-cache' ) . '</h4>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Tailored W3 Total Cache setup, customized for your theme, plugins, and server.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Expert optimization based on WordPress-specific performance needs (WPO).', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Avoid harmful configurations like improper minification or caching.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Receive a detailed performance report with improvements and recommendations.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Proven to boost your site speed—ideal for unique traffic and site needs.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Start your optimization journey with W3 Total Cache as the foundation.', 'w3-total-cache' ) . '</p>

				<div class="cta-button">
					<a href="' . esc_url( Util_UI::admin_url( 'admin.php?page=w3tc_support' ) ) . '"> ' . esc_html__( 'Click here to purchase this premium service', 'w3-total-cache' ) . ' </a>
				</div>',
		),
	),
	'cdn'            => array(
		'tabs' => array(
			'premium_support' => '<h3>' . esc_html__( 'Did you know that W3 Total Cache has premium services available, and can help you with your Full Site Delivery via CDN?', 'w3-total-cache' ) . '</h3>
				<h4>' . esc_html__( 'Optimize Your WordPress Site with the Full Site Delivery (FSD) CDN service', 'w3-total-cache' ) . '</h4>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'FSD CDN accelerates website load times by caching and delivering entire web pages.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Acts as a proxy server to retrieve and serve content faster, reducing server response time.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Optimized for full page delivery, not just static files, enhancing overall site performance.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Setup includes integration with W3 Total Cache FSD CDN Pro for seamless performance.', 'w3-total-cache' ) . '</p>
				<p><span class="dashicons dashicons-yes-alt"></span>' . esc_html__( 'Compatible with top CDN providers like Bunny CDN, Transparent CDN, Amazon, and Cloudflare.', 'w3-total-cache' ) . '</p>

				<div class="cta-button">
					<a href="' . esc_url( Util_UI::admin_url( 'admin.php?page=w3tc_support' ) ) . '"> ' . esc_html__( 'Click here to purchase this premium service', 'w3-total-cache' ) . ' </a>
				</div>',
		),
	),
);
